#define comment ___comment
#include "core.h"
#undef comment
#include "process.h"
#include "master.h"
#include "sigmask.h"
#include "frame.h"
#include "memory.h"
#include "symtab.h"
#include "symbol.h"
#include "srcdir.h"
#include "asm.h"
#include "bpts.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "nrtx.h"
SRCFILE("nrtx.c")

void NrtxMaster::open()
{
	Menu m, k;

	if (pad) {
		pad->makecurrent();
		return;
	}
	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED|ACCEPT_KBD);
	pad->name( "%s:%s", parent->name(), name());
	pad->banner( "Rtpi - NRTX - %s:%s", parent->name(), name());
	m.last("ps", (Action)&NrtxMaster::refresh, 1);
	k.last("kernel pi", (Action)&NrtxMaster::kpi);
	m.last(k.index("kernel"));
	pad->menu(m);
	pad->makecurrent();
	refresh(0);
}

void NrtxMaster::kpi()
{
	if (!kernel)
		kernel = newDbmonMaster();
	kernel->open();
}

void NrtxMaster::refresh(int c)
{
	char s[128];
	Process *p;

	pad->clear();
//	makeproc( "!", "a.out", 0);
	if (c) {
		int np = 0;
		::dbrequest(fd, boardid, 0,
			    DBR_NRTXNPROC, (int)&np, 0, sizeof(np));
		np = (int)db_ntohl(np);
		for(int i = 0; i < np; i++) {
			int r = ::dbrequest(fd, boardid, i,
					DBR_GETSNAME, (int)s, 0,sizeof(s));
			if (r >= 0)
				makeproc(sf("%s:%d",name(), i),sf("%s", s), 0);
		}
	}
	for( p = child; p; p = p->sibling )
		if( p->core || (p->stabpath && !strcmp(p->stabpath,"!")))
			insert(p);
}

char *NrtxMaster::kbd(char *s)
{
	char core[64], syms[64];

	while (*s == ' ') ++s;
//	if (*s == '!') {
//		for (++s; *s==' '; ++s) {}
//		makeproc("!", s);
//	} else {
		int i = sscanf(s, "%s %s \n", core, syms);
		if (i <= 0 || i > 2 || !alldigits(core))
			return "Incorrect input: type ? for help";
		makeproc(sf("%s:%s",name(), core), i==2 ? sf("%s",syms) : 0);
//	}
	return 0;
}

char *NrtxMaster::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Nrtxpi Window";
		case HELP_MENU:		return "Nrtxpi Menu Bar";
		case HELP_KEY:		return "Nrtxpi Keyboard";
		case HELP_LMENU:	return "Nrtxpi Line Menu";
		default:		return 0;
	}
}

NrtxProcess::NrtxProcess(int f, int b, int pid, Process *sib, char *p,
	char *s, char *c) : Process(sib,p,s,c)
{
	fd = f;
	boardid = b;
	pipeid = pid;
}

void NrtxProcess::takeover()
{
	if( pad ){
		open();
		insert(ERRORKEY, "take over: already open");
		return;
	}
	Pick( "take over", (Action)&NrtxProcess::substitute, (long) this );
}

int NrtxProcess::accept( Action a )
{
	return a == (Action)&NrtxProcess::substitute;
}

void NrtxProcess::userclose()
{
	if( sigmsk ){
		sigmsk->hostclose();
		delete sigmsk;
		sigmsk = 0;
	}
	Process::userclose();
	::dbrequest(fd, boardid, procid, DBR_CLOSE,0,0,0);
}

void NrtxProcess::substitute(NrtxProcess *t)
{
	char *error;

	insert(ERRORKEY, 0);
	if( !core ){
		insert(ERRORKEY, "that ought to work - but it doesn't");
		return;
	}
	_bpts->lift();
	if( error = core->reopen(0,t->stabpath) ){
		_bpts->lay();
		insert(ERRORKEY, error);
		return;
	}
	procpath = t->procpath;
	stabpath = t->stabpath;
	comment = t->comment;
	::dbrequest(fd, boardid, procid, DBR_CLOSE,0,0,0);
	sscanf(strchr(procpath,':')+1, "%d", &procid);
	t->isdead = 1;
	master->insert(t);
	master->insert(this);
	banner();
	if( _asm ) _asm->banner();
	if( _bpts ) _bpts->banner();
	if( memory ) memory->banner();
	if( globals ) globals->banner();
	if( sigmsk ){
		sigmsk->banner();
		sigmsk->updatecore();
	}
	if( srcdir ) srcdir->banner();
	core->symtab()->banner();
	pad->clear();
	_bpts->lay();
	docycle();
}

void NrtxProcess::open()
{
	Menu m, s, k;
	char *error;

	Process::openpad();
	if( core ) return;
	sscanf(strchr(procpath,':')+1, "%d", &procid);
	insert(ERRORKEY, "Checking process and symbol table...");
	core = newCore(master);
	if( error = core->open() ){
		delete core;
		core = 0;
		m.last( "open process", (Action)&NrtxProcess::open);
		pad->menu( m );
		insert(ERRORKEY, error);
		return;
	}
	insert(ERRORKEY, core->symtab()->warn());
	globals = new Globals(core);
	_asm = core->newAsm();
	_bpts = new Bpts(core);
	_bpts->lay();
	sigmsk = new SigMask(core);

	m.last( "Source",	(Action)&Process::srcfiles    );
	m.last( "Globals",	(Action)&Process::openglobals );
	m.last( "Memory",	(Action)&Process::openmemory  );
	m.last( "Assembler",	(Action)&Process::openasm     );
	m.last( "User Types",	(Action)&Process::opentypes   );
	m.last( "Journal",	(Action)&Process::openjournal );
	m.last( "Signals",	(Action)&NrtxProcess::opensigmask);
	m.last( "Breakpoints",	(Action)&Process::openbpts    );

	s.last( "run",		(Action)&Process::go          );
	s.last( "stop",		(Action)&Process::stop        );
	s.last( "current",	(Action)&Process::currentstmt );
	s.last( "return",	(Action)&Process::pop         );
	s.last( "step into",	(Action)&Process::stepinto    );
	s.last( "step   1",	(Action)&Process::stmtstep, 1 );
	s.last( "step   5",	(Action)&Process::stmtstep, 5 );
	s.last( "step  25",	(Action)&Process::stmtstep, 25);
	s.last( "step 100",	(Action)&Process::stmtstep, 100);
	s.last( "step 500",	(Action)&Process::stmtstep, 500);
	m.last(s.index("stmt"));

	k.last( "kill?",	(Action)&NrtxProcess::destroy);
	m.last(k.index("kill"));

	pad->menu(m.index("views"));
	pad->makecurrent();
	docycle();
}

void NrtxProcess::opensigmask() { if (sigmsk) sigmsk->open(); }

void NrtxProcess::destroy()
{
	insert(ERRORKEY, core->destroy());
	docycle();
}

Index NrtxProcess::carte()
{
	Menu m;
//	if(procpath && !strcmp(procpath,"!") ){
//		m.last("hang & open proc",(Action)&NrtxProcess::hangopen);
//		m.last("hang & take over",(Action)&NrtxProcess::hangtakeover);
//	} else {
		m.last("open process", (Action)&NrtxProcess::open);
		m.last("take over", (Action)&NrtxProcess::takeover);
//	}
	return m.index();
}

void NrtxProcess::hang()
{
	insert(ERRORKEY, "can't load real-time board");
//	procpath = sf("%s:-2",((NrtxMaster*)master)->name());
//	master->makeproc("!", stabpath);
//	master->insert(this);
}

void NrtxProcess::hangopen()
{
	hang();
	open();
}

void NrtxProcess::hangtakeover()
{
	hang();
	takeover();
}

const long REG_SPECIAL = 0x40000000;	// Address unlikely to be used

Behavs NrtxCore::behavs()	{ readcontrol(); return behavetype(); }
char *NrtxCore::destroy()	{ return dbreq(DBR_KILL, 0, 9); }
long NrtxCore::regaddr()	{ return REG_SPECIAL; }
char *NrtxCore::run()		{ return dbreq(DBR_RUN); }
long NrtxCore::scratchaddr()	{ return scratch; }
char *NrtxCore::stop()		{ return dbreq(DBR_KILL, 0, SIGSTOP); }
char *NrtxCore::eventname()	{ return signalname(pr.p_cursig); }

NrtxCore::NrtxCore(int f, int b, int p, int i)
{
	commfd = f;
	boardid = b;
	pipeid = p;
	procid = i;
}

char *NrtxCore::problem()
{
	if (::dberrno == DBA_BAD)
		return "process exited";
	return sf("communications time out (%d)", dberrno);
}

char *NrtxCore::readcontrol()
{
	char *error = dbreq(DBR_NRTXPROC, (char*)&pr, 0, sizeof(pr));
	if (error) {
		if (dberrno == DBA_KSTOPPED)
			return 0;
		pr.p_stat = 0;
	}
	return error;
}

char *NrtxCore::dbreq(int req, char* addr,int rarg, int sz)
{ 
	if (::dbrequest(commfd, boardid, procid, req,
			(int)addr, rarg, sz) == -1)
		return "dbrequest failed";
	return 0;
}

char *NrtxCore::laybpt(Trap *t)
{
	if (bptsize && read(t->stmt->range.lo, t->saved, bptsize))
		return "laybpt: read failed";
	return dbreq(DBR_SETBKPT, 0, (int)t->stmt->range.lo);
}

Behavs NrtxCore::behavetype()
{
	switch( pr.p_stat ){
	case SSLEEP:
	case SRUN:
		return ACTIVE;
	case SSTOP:
		switch( pr.p_cursig ){
		case SIGSTOP:
			return HALTED;
		case SIGTRAP:
			return BREAKED;
		default:
			return PENDING;
		}
	}
	return ERRORED;
}

char *NrtxCore::open()
{
	if( stabpath() ){
		stabfd = ::open(stabpath(),0);
		if( stabfd<0 ) return SysErr( "symbol tables: " );
	} else
		return "open error";
	dbreq(DBR_GETSCRATCH, (char*)&scratch, 0, sizeof(scratch));
	scratch = db_ntohl(scratch);
	_online = 1;
	dbreq(DBR_OPEN);
	stabfstat();
	long reloc;
	dbreq(DBR_NRTXRELOC, (char*)&reloc, 0, sizeof(reloc));
	reloc = db_ntohl(reloc);
	newSymTab(reloc);
	_symtab->read();
	return readcontrol();
}

char *NrtxCore::reopen(char *, char *newstabpath)
{
	int compstabfd = ::open(newstabpath, 0);
	struct stat compstabstat;
	if( compstabfd < 0 || ::fstat(compstabfd, &compstabstat) )
		return "symbol table error";
	if( compstabstat.st_mtime != stabstat.st_mtime )
		return "symbol tables differ (modified time)";
	if( compstabstat.st_size != stabstat.st_size )
		return "symbol tables differ (file size)";
	::close(compstabfd);
	return readcontrol();
}

char *NrtxCore::readwrite(long offset, char *buf, int r, int w)
{
	if (offset >= REG_SPECIAL && offset <= (REG_SPECIAL + regsize)) {
		offset -= REG_SPECIAL;
		if( r ) return dbreq(DBR_GETREGS, buf, (int)offset, r);
		return dbreq(DBR_PUTREGS, buf, (int)offset, w);
	}
	if( r ) return dbreq(DBR_READ, buf, (int)offset, r);
	return dbreq(DBR_WRITE, buf, (int)offset, w);
}

const int	STEPWAIT = 15;
char *NrtxCore::dostep(long lo, long hi, int sstep)
{
	char *error;
	long fp0, pcs, time0;
	int i;
	static int waittime[] = {1,1,2,4,6};

	if (pr.p_cursig==SIGTRAP)
		signalclear();
	time0 = ::time((long*)0);
	for(fp0 = fp(), pcs = pc();;){
		if( hi && atjsr(pcs) ) {
			error = stepoverjsr();
			goto next;
		}
		if (sstep)
			error = dbreq(DBR_STEP);
		else
			error = run();
		if( !error ) {
			for (i = 0; ; i++) {
				error = readcontrol();
				if (error || behavetype() != ACTIVE)
					break;
				if (i >= 5)
					return "single step timeout";
				sleep(waittime[i]);
			}
		}
		if( !error && pr.p_cursig != SIGTRAP )
			error = sf("single step error. signal=%d",pr.p_cursig);
		if( !error ) error = signalclear();
next:
		if( error ) return error;
		if( !hi || (pcs = pc()) < lo || pcs >= hi
		 || ((stackdir == GROWDOWN ? (fp() > fp0) : (fp() < fp0))
		     && !atreturn(pcs)) )
			return 0;
		if( ::time((long*)0) > time0+STEPWAIT )
			return sf("single step timeout (%d secs)", STEPWAIT);
	}
}

int NrtxCore::nsig()			{ return 32; }
int NrtxCore::exechangsupported()	{ return 1; }
char *NrtxCore::signalsend(long sig)	{ return dbreq(DBR_KILL, 0, (int)sig);}

#define bit(x)	(1<<(x-1))
char *NrtxCore::signalmask(long mask)
{
	long sysmask = bit(SIGSTOP) | bit(SIGTRAP);
	if ((mask & sysmask) != sysmask)
		process()->error("warning: debugging signal disabled");
	return dbreq(DBR_SMASK, 0, (int)mask);
}

char *NrtxCore::signalclear()
{
	char *error = dbreq(DBR_CSIG);
	if( !error )
		pr.p_cursig = 0;
	return error;
}

char *NrtxCore::exechang(long ehang)
{
	if (ehang)
		return dbreq(DBR_SEXEC);
	else
		return dbreq(DBR_REXEC);
}

char *NrtxCore::signalname(long sig)
{
	switch (sig) {
		case 0:		return "0 (no signal)";
		case SIGHUP:	return "hangup";
		case SIGINT:	return "interrupt";
		case SIGQUIT:	return "quit";
		case SIGILL:	return "illegal instruction";
		case SIGTRAP:	return "trace/BPT";
		case SIGIOT:	return "IOT instruction";
		case SIGEMT:	return "EMT instruction";
		case SIGFPE:	return "floating exception";
		case SIGKILL:	return "kill";
		case SIGBUS:	return "bus error";
		case SIGSEGV:	return "memory fault";
		case SIGSYS:	return "bad system call";
		case SIGPIPE:	return "broken pipe";
		case SIGALRM:	return "alarm call";
		case SIGTERM:	return "terminated";
		case SIGSTOP:	return "stop";
		case SIGCONT:	return "continue";
		case SIGCHLD:	return "child termination";
	}
	return sf("Signal %d", sig);
}

long NrtxCore::signalmaskinit()
{
	return	bit(SIGILL)|bit(SIGINT)|bit(SIGTRAP)|bit(SIGIOT)|
		bit(SIGEMT)|bit(SIGFPE)|bit(SIGBUS)|bit(SIGSEGV)|
		bit(SIGSYS)|bit(SIGPIPE)|bit(SIGSTOP);
}
